/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.datagen;

import mcjty.lib.datagen.BaseBlockStateProvider;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControlBlock;
import mcjty.rftoolsbuilder.modules.shield.ShieldModule;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BaseBlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "rftoolsbuilder", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.singleTextureBlock((Block)ShieldModule.TEMPLATE_BLUE.get(), "blue_shield_template", "block/shieldtemplate");
        this.singleTextureBlock((Block)ShieldModule.TEMPLATE_RED.get(), "red_shield_template", "block/shieldtemplate1");
        this.singleTextureBlock((Block)ShieldModule.TEMPLATE_GREEN.get(), "green_shield_template", "block/shieldtemplate2");
        this.singleTextureBlock((Block)ShieldModule.TEMPLATE_YELLOW.get(), "yellow_shield_template", "block/shieldtemplate3");
        this.horizontalOrientedBlock((Block)BuilderModule.BUILDER.get(), this.frontBasedModel("builder", this.modLoc("block/machinebuilder")));
        this.singleTextureBlock((Block)BuilderModule.SPACE_CHAMBER.get(), "space_chamber", "block/machinespacechamber");
        this.singleTextureBlock((Block)BuilderModule.SPACE_CHAMBER_CONTROLLER.get(), "space_chamber_controller", "block/machinespacechambercontroller");
        this.simpleBlock((Block)MoverModule.MOVER.get(), this.frontBasedModel("mover", this.modLoc("block/machinemover"), this.modLoc("block/machinemover"), RFTOOLSBASE_TOP, RFTOOLSBASE_BOTTOM));
        this.orientedBlock((Block)MoverModule.MOVER_CONTROLLER.get(), this.frontBasedModel("mover_controller", this.modLoc("block/machinemovercontroller")));
        this.orientedBlock((Block)MoverModule.VEHICLE_BUILDER.get(), this.frontBasedModel("vehicle_builder", this.modLoc("block/machinevehiclebuilder")));
        this.create24Model((Block)MoverModule.MOVER_CONTROL_BLOCK.get(), "mover_control_", "block/movercontrol");
        this.create24Model((Block)MoverModule.MOVER_CONTROL2_BLOCK.get(), "mover_control2_", "block/movercontrol2");
        this.create24Model((Block)MoverModule.MOVER_CONTROL3_BLOCK.get(), "mover_control3_", "block/movercontrol3");
        this.create24Model((Block)MoverModule.MOVER_CONTROL4_BLOCK.get(), "mover_control4_", "block/movercontrol4");
        this.create24Model((Block)MoverModule.MOVER_STATUS_BLOCK.get(), "mover_status_", "block/moverstatus");
        BlockModelBuilder support0 = (BlockModelBuilder)this.models().cubeAll("supportblock_status0", this.modLoc("block/supportblock"));
        BlockModelBuilder support1 = (BlockModelBuilder)this.models().cubeAll("supportblock_status1", this.modLoc("block/supportyellowblock"));
        BlockModelBuilder support2 = (BlockModelBuilder)this.models().cubeAll("supportblock_status2", this.modLoc("block/supportredblock"));
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)BuilderModule.SUPPORT.get());
        builder.partialState().with(SupportBlock.STATUS, (Comparable)((Object)SupportBlock.SupportStatus.STATUS_OK)).modelForState().modelFile((ModelFile)support0).addModel();
        builder.partialState().with(SupportBlock.STATUS, (Comparable)((Object)SupportBlock.SupportStatus.STATUS_WARN)).modelForState().modelFile((ModelFile)support1).addModel();
        builder.partialState().with(SupportBlock.STATUS, (Comparable)((Object)SupportBlock.SupportStatus.STATUS_ERROR)).modelForState().modelFile((ModelFile)support2).addModel();
        ModelBuilder shieldModel = this.models().cubeAll("shield_block", this.modLoc("block/machineshieldprojector"));
        this.simpleBlock((Block)ShieldModule.SHIELD_BLOCK1.get(), (ModelFile)shieldModel);
        this.simpleBlock((Block)ShieldModule.SHIELD_BLOCK2.get(), (ModelFile)shieldModel);
        this.simpleBlock((Block)ShieldModule.SHIELD_BLOCK3.get(), (ModelFile)shieldModel);
        this.simpleBlock((Block)ShieldModule.SHIELD_BLOCK4.get(), (ModelFile)shieldModel);
        ModelFile.UncheckedModelFile shieldingModel = new ModelFile.UncheckedModelFile(new ResourceLocation("rftoolsbuilder", "block/shielding"));
        this.simpleBlock((Block)ShieldModule.SHIELDING_SOLID.get(), (ModelFile)shieldingModel);
        this.simpleBlock((Block)ShieldModule.SHIELDING_TRANSLUCENT.get(), (ModelFile)shieldingModel);
        this.simpleBlock((Block)ShieldModule.SHIELDING_CUTOUT.get(), (ModelFile)shieldingModel);
    }

    private void create24Model(Block block, String modelPrefix, String txt) {
        ModelFile model0 = this.controlModuleBlock(modelPrefix + "0", this.modLoc(txt), 0, ModelBuilder.FaceRotation.ZERO);
        ModelFile model90 = this.controlModuleBlock(modelPrefix + "90", this.modLoc(txt), 0, ModelBuilder.FaceRotation.CLOCKWISE_90);
        ModelFile model180 = this.controlModuleBlock(modelPrefix + "180", this.modLoc(txt), 0, ModelBuilder.FaceRotation.UPSIDE_DOWN);
        ModelFile model270 = this.controlModuleBlock(modelPrefix + "270", this.modLoc(txt), 0, ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90);
        this.orientedBlock(block, (blockState, bld) -> {
            ModelFile model = this.getModelOriented24(model0, model90, model180, model270, (BlockState)blockState);
            bld.modelFile(model);
        });
    }

    private ModelFile getModelOriented24(ModelFile model0, ModelFile model90, ModelFile model180, ModelFile model270, BlockState blockState) {
        ModelFile model = switch ((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> {
                switch ((Direction)blockState.m_61143_((Property)MoverControlBlock.HORIZ_FACING)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOWN: {
                        yield model0;
                    }
                    case UP: {
                        yield model0;
                    }
                    case NORTH: {
                        yield model0;
                    }
                    case SOUTH: {
                        yield model180;
                    }
                    case WEST: {
                        yield model270;
                    }
                    case EAST: 
                }
                yield model90;
            }
            case Direction.DOWN -> {
                switch ((Direction)blockState.m_61143_((Property)MoverControlBlock.HORIZ_FACING)) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case DOWN: {
                        yield model0;
                    }
                    case UP: {
                        yield model0;
                    }
                    case NORTH: {
                        yield model180;
                    }
                    case SOUTH: {
                        yield model0;
                    }
                    case WEST: {
                        yield model90;
                    }
                    case EAST: 
                }
                yield model270;
            }
            case Direction.NORTH -> model0;
            case Direction.SOUTH -> model0;
            case Direction.WEST -> model0;
            case Direction.EAST -> model0;
        };
        return model;
    }

    public ModelFile controlModuleBlock(String modelName, ResourceLocation texture, int offset, ModelBuilder.FaceRotation faceRotation) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/" + modelName)).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block")));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().from(0.0f, 0.0f, (float)offset).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).cullface(Direction.DOWN).texture("#side").end().face(Direction.UP).cullface(Direction.UP).texture("#top").end().face(Direction.EAST).cullface(Direction.EAST).texture("#side").end().face(Direction.WEST).cullface(Direction.WEST).texture("#side").end().face(Direction.NORTH).texture("#front").rotation(faceRotation).end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#side").end().end()).texture("side", RFTOOLSBASE_SIDE)).texture("top", RFTOOLSBASE_TOP)).texture("particle", RFTOOLSBASE_SIDE)).texture("front", texture);
        return model;
    }
}

